/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills;

import dev.toma.gunsrpg.api.common.attribute.IValueFormatter;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.skill.IDescriptionProvider;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.common.skills.SimpleSkill;
import dev.toma.gunsrpg.common.skills.core.DescriptionContainer;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;

public class WellFedSkill
extends SimpleSkill
implements IDescriptionProvider {
    private final DescriptionContainer container;
    private final int level;
    private final float chance;

    public WellFedSkill(SkillType<?> type, int level, float chance) {
        super(type);
        this.level = level;
        this.chance = chance;
        this.container = new DescriptionContainer(type);
        this.container.addProperty("chance", IValueFormatter.PERCENT.formatAttributeValue(chance));
    }

    @Override
    public ITextComponent[] supplyDescription(int desiredLineCount) {
        return this.container.getLines();
    }

    public void applyEffects(PlayerEntity player, IPlayerData data) {
        Random random = new Random();
        if (player.field_70170_p.field_72995_K || random.nextFloat() >= this.chance) {
            return;
        }
        int amplifier = this.level - 1;
        int duration = (int)((double)(1200 + amplifier * 600) * data.getAttributes().getAttributeValue(Attribs.WELL_FED_DURATION));
        player.func_195064_c(new EffectInstance(Effects.field_76444_x, duration, amplifier));
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(ModSounds.USE_WELL_FED, SoundCategory.MASTER, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 1.0f, 1.0f));
    }
}

